<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'password', 'admin');
    protected $visible = array('name', 'email', 'admin');

    public function returnedGps()
    {
        return $this->hasMany('GpsJob', 'returned_by');
    }

    public function deliveredGps()
    {
        return $this->hasMany('GpsJob', 'delivered_by');
    }

}